<?php
/**
 * WebEngine Lottery Plugin
 * https://webenginecms.org/
 * 
 * @version 2.3.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2021 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

function saveChanges() {
    global $_POST;
    foreach($_POST as $setting) {
        if(!check_value($setting)) {
            message('error', 'Missing data (complete all fields).');
            return;
        }
    }
    $xmlPath = __PATH_LOTTERY_ROOT__.'config.xml';
    $xml = simplexml_load_file($xmlPath);

	$xml->active = $_POST['setting_1'];
	
	if(!Validator::UnsignedNumber($_POST['setting_2'])) throw new Exception('The initial jackpot must be a numeric value.');
	$xml->initial_jackpot = $_POST['setting_2'];
	
	if(!Validator::UnsignedNumber($_POST['setting_3'])) throw new Exception('The ticket minimum number must be a numeric value.');
	$xml->min_number = $_POST['setting_3'];
	
	if(!Validator::UnsignedNumber($_POST['setting_4'])) throw new Exception('The ticket maximum number must be a numeric value.');
	$xml->max_number = $_POST['setting_4'];
	
	if($_POST['setting_3'] > $_POST['setting_4']) throw new Exception('The ticket minimum number must be smaller than the maximum number.');
	
	if(!Validator::UnsignedNumber($_POST['setting_5'])) throw new Exception('The ticket cost must be a numeric value.');
	$xml->ticket_cost = $_POST['setting_5'];
	
	if(!Validator::UnsignedNumber($_POST['setting_6'])) throw new Exception('The ticket profit must be a numeric value.');
	if(!Validator::Number($_POST['setting_6'], 101, -1)) throw new Exception('The ticket profit value must be 0 to 100.');
	$xml->ticket_profit = $_POST['setting_6'];
	
	if(!Validator::UnsignedNumber($_POST['setting_7'])) throw new Exception('The 4 number match must be a numeric value.');
	if(!Validator::Number($_POST['setting_7'], 101, -1)) throw new Exception('The 4 number match value must be 0 to 100.');
	$xml->matches_4 = $_POST['setting_7'];
	
	if(!Validator::UnsignedNumber($_POST['setting_8'])) throw new Exception('The 3 number match must be a numeric value.');
	if(!Validator::Number($_POST['setting_8'], 101, -1)) throw new Exception('The 3 number match value must be 0 to 100.');
	$xml->matches_3 = $_POST['setting_8'];
	
	if(!Validator::UnsignedNumber($_POST['setting_9'])) throw new Exception('The 2 number match must be a numeric value.');
	if(!Validator::Number($_POST['setting_9'], 101, -1)) throw new Exception('The 2 number match value must be 0 to 100.');
	$xml->matches_2 = $_POST['setting_9'];
	
	if(!Validator::UnsignedNumber($_POST['setting_10'])) throw new Exception('The 1 number match must be a numeric value.');
	if(!Validator::Number($_POST['setting_10'], 101, -1)) throw new Exception('The 1 number match value must be 0 to 100.');
	$xml->matches_1 = $_POST['setting_10'];
	
	if(($_POST['setting_7']+$_POST['setting_8']+$_POST['setting_9']+$_POST['setting_10']) > 100) throw new Exception('Winning percentage sum must equal to 100.');
	
	$Lottery = new \Plugin\Lottery\Lottery();
	$weekDays = $Lottery->getWeekDays();
	
	if(!array_key_exists($_POST['setting_11'], $weekDays)) throw new Exception('The selected starting day is not valid.');
	$xml->schedule_start = $_POST['setting_11'];
	
	if(!preg_match('#^([01]?[0-9]|2[0-3]):[0-5][0-9](:[0-5][0-9])?$#', $_POST['setting_12'])) throw new Exception('The selected starting day time format is not valid.');
	$xml->schedule_start_time = $_POST['setting_12'];
	
	if(!array_key_exists($_POST['setting_13'], $weekDays)) throw new Exception('The selected number reveal day is not valid.');
	$xml->schedule_reveal = $_POST['setting_13'];
	
	if(!preg_match('#^([01]?[0-9]|2[0-3]):[0-5][0-9](:[0-5][0-9])?$#', $_POST['setting_14'])) throw new Exception('The selected number reveal day time format is not valid.');
	$xml->schedule_reveal_time = $_POST['setting_14'];
	
	if(!array_key_exists($_POST['setting_15'], $weekDays)) throw new Exception('The selected ending day is not valid.');
	$xml->schedule_end = $_POST['setting_15'];
	
	if(!preg_match('#^([01]?[0-9]|2[0-3]):[0-5][0-9](:[0-5][0-9])?$#', $_POST['setting_16'])) throw new Exception('The selected ending day time format is not valid.');
	$xml->schedule_end_time = $_POST['setting_16'];
	
	if(!Validator::UnsignedNumber($_POST['setting_17'])) throw new Exception('The credit config must be a numeric value.');
	$xml->credit_config = $_POST['setting_17'];
	
	if(!Validator::UnsignedNumber($_POST['setting_18'])) throw new Exception('The history limit must be a numeric value.');
	$xml->history_limit = $_POST['setting_18'];
	
    $save = @$xml->asXML($xmlPath);
	if(!$save) throw new Exception('There has been an error while saving changes.');
}

if(check_value($_POST['submit_changes'])) {
	try {
		
		saveChanges();
		message('success', 'Settings successfully saved.');
		
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

if(check_value($_GET['checkusercplinks'])) {
	try {
		$Lottery = new \Plugin\Lottery\Lottery();
		$Lottery->checkPluginUsercpLinks();
		message('success', 'UserCP Links Successfully Added!');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

function buildWeekDaySelect($weekDays = array(), $setting, $selected) {
	if(!is_array($weekDays)) return;
	foreach($weekDays as $weekDayNumber => $weekDay) {
		echo '<div class="radio">';
			echo '<label>';
				if($selected == $weekDayNumber) {
					echo '<input type="radio" name="'.$setting.'" id="'.$setting.'" value="'.$weekDayNumber.'" checked> ' . $weekDay;
				} else {
					echo '<input type="radio" name="'.$setting.'" id="'.$setting.'" value="'.$weekDayNumber.'"> ' . $weekDay;
				}
			echo '</label>';
		echo '</div>';
	}
}

// load configs
$lotteryConfig = simplexml_load_file(__PATH_LOTTERY_ROOT__.'config.xml');
if(!$lotteryConfig) throw new Exception('Error loading config file.');
$lotteryConfig = convertXML($lotteryConfig->children());
if(!is_array($lotteryConfig)) throw new Exception('Error loading config file.');

$Lottery = new \Plugin\Lottery\Lottery();
$creditSystem = new CreditSystem();
?>
<h2>Lottery Settings</h2>
<form action="" method="post">
    <table class="table table-striped table-bordered table-hover module_config_tables">
        <tr>
            <th>Status<br/><span>Enable/disable the lottery System.</span></th>
            <td>
                <?php enabledisableCheckboxes('setting_1', $lotteryConfig['active'], 'Enabled', 'Disabled'); ?>
            </td>
        </tr>
    </table>
	
	<h4 style="color:#DB5B00;">General Settings</h4>
	<table class="table table-striped table-bordered table-hover module_config_tables">
        <tr>
            <th>Initial Jackpot<br/><span>Define what the initial jackpot will be.</span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_2" value="<?php echo $lotteryConfig['initial_jackpot']; ?>"/>
					<div class="input-group-addon">credits</div>
				</div>
            </td>
        </tr>
		<tr>
            <th>Ticket Minimum Number<br/><span>Define the ticket minimum number.</span></th>
            <td>
                <input class="form-control" type="text" name="setting_3" value="<?php echo $lotteryConfig['min_number']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Ticket Maximum Number<br/><span>Define the ticket maximum number.</span></th>
            <td>
				<input class="form-control" type="text" name="setting_4" value="<?php echo $lotteryConfig['max_number']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Ticket Cost<br/><span>Define the cost of a ticket.</span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_5" value="<?php echo $lotteryConfig['ticket_cost']; ?>"/>
					<div class="input-group-addon">credits</div>
				</div>
            </td>
        </tr>
		<tr>
            <th>Ticket Profit<br/><span>Define the percentage of the ticket that you will <strong>keep</strong>.<br /><br />Example:<br />If you set this value to <strong>80%</strong> then only <strong>20%</strong> of the ticket's value will be accumulated to the jackpot.</span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_6" value="<?php echo $lotteryConfig['ticket_profit']; ?>"/>
					<div class="input-group-addon">%</div>
				</div>
            </td>
        </tr>
		<tr>
            <th>Ticket History Limit<br/><span>Define the amount of tickets to be shown in the ticket purchase history.</span></th>
            <td>
				<input class="form-control" type="text" name="setting_18" value="<?php echo $lotteryConfig['history_limit']; ?>"/>
            </td>
        </tr>
    </table>
	
	<h4 style="color:#DB5B00;">Matches Winning Percentages</h4>
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
            <th>All Numbers Match<br/><span>Define the percentage of the jackpot that will be reserved to lottery players who matched all numbers. <strong>This percentage is divided between all the winners.</strong></span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_7" value="<?php echo $lotteryConfig['matches_4']; ?>"/>
					<div class="input-group-addon">% of jackpot</div>
				</div>
            </td>
        </tr>
		<tr>
            <th>3 Numbers Match<br/><span>Define the percentage of the jackpot that will be reserved to lottery players who matched 3 numbers. <strong>This percentage is divided between all the winners.</strong></span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_8" value="<?php echo $lotteryConfig['matches_3']; ?>"/>
					<div class="input-group-addon">% of jackpot</div>
				</div>
            </td>
        </tr>
		<tr>
            <th>2 Numbers Match<br/><span>Define the percentage of the jackpot that will be reserved to lottery players who matched 2 numbers. <strong>This percentage is divided between all the winners.</strong></span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_9" value="<?php echo $lotteryConfig['matches_2']; ?>"/>
					<div class="input-group-addon">% of jackpot</div>
				</div>
            </td>
        </tr>
		<tr>
            <th>1 Number Matches<br/><span>Define the percentage of the jackpot that will be reserved to lottery players who matched 1 number. <strong>This percentage is divided between all the winners.</strong></span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_10" value="<?php echo $lotteryConfig['matches_1']; ?>"/>
					<div class="input-group-addon">% of jackpot</div>
				</div>
            </td>
        </tr>
    </table>
	
	<h4 style="color:#DB5B00;">Automatic Schedule</h4>
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
            <th>Starting Day<br/><span>Select the day on which the lottery should be scheduled to begin.</span></th>
            <td>
				<?php buildWeekDaySelect($Lottery->getWeekDays(), "setting_11", $lotteryConfig['schedule_start']); ?>
            </td>
        </tr>
		<tr>
            <th>Starting Time<br/><span>Define the time <strong>in a 24-hour format</strong> in which the lottery should be scheduled to begin.<br /><br />hh:mm:ss</span></th>
            <td>
                <input class="form-control" type="text" name="setting_12" value="<?php echo $lotteryConfig['schedule_start_time']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Number Reveal Day<br/><span>Select the day on which the lottery should be scheduled to reveal the numbers. (lottery ends this day)</span></th>
            <td>
				<?php buildWeekDaySelect($Lottery->getWeekDays(), "setting_13", $lotteryConfig['schedule_reveal']); ?>
            </td>
        </tr>
		<tr>
            <th>Number Reveal Time<br/><span>Define the time <strong>in a 24-hour format</strong> in which the lottery should be scheduled to reveal the numbers.<br /><br />hh:mm:ss</span></th>
            <td>
                <input class="form-control" type="text" name="setting_14" value="<?php echo $lotteryConfig['schedule_reveal_time']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Ending Day<br/><span>Select the day on which the lottery should be scheduled to end and re-schedule itself.</span></th>
            <td>
				<?php buildWeekDaySelect($Lottery->getWeekDays(), "setting_15", $lotteryConfig['schedule_end']); ?>
            </td>
        </tr>
		<tr>
            <th>Ending Time<br/><span>Define the time <strong>in a 24-hour format</strong> in which the lottery should be scheduled to end and re-schedule itself.<br /><br />hh:mm:ss</span></th>
            <td>
                <input class="form-control" type="text" name="setting_16" value="<?php echo $lotteryConfig['schedule_end_time']; ?>"/>
            </td>
        </tr>
    </table>
	
	<h4 style="color:#DB5B00;">Credits Configurations</h4>
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
			<th>Credit Configuration<br/><span>Select to which credit configuration the stash credits will be transferred to.</span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_17", $lotteryConfig['credit_config'], "form-control"); ?>
			</td>
		</tr>
	</table>
	
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
            <td colspan="2"><input type="submit" name="submit_changes" value="Save Changes" class="btn btn-success"/></td>
        </tr>
    </table>
</form>

<h2>UserCP Links</h2>
<p>Click the button below to automatically add the plugin's links to the user control panel menu.</p>
<a href="<?php echo admincp_base('lottery&page=settings&checkusercplinks=1'); ?>" class="btn btn-primary">Add UserCP Links</a>